<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="mc-header">
    <div class="mc-header-inner">
        <div class="mc-brand">
            <div class="mc-brand-lockup">
                <?php
                $logo_html = function_exists('get_custom_logo') ? get_custom_logo() : '';
                if (!$logo_html) {
                    $site_icon = function_exists('get_site_icon_url') ? get_site_icon_url(256) : '';
                }
                ?>
                <?php if (!empty($logo_html)) : ?>
                    <div class="mc-logo">
                        <?php echo $logo_html; ?>
                    </div>
                    <span class="mc-logo-sub">Custom Paint & Airbrush Studio</span>
                <?php elseif (!empty($site_icon)) : ?>
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="mc-brand-link">
                        <span class="mc-logo-mark mc-logo-image" aria-hidden="true">
                            <img src="<?php echo esc_url($site_icon); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" class="custom-logo">
                        </span>
                        <span class="mc-logo-text">
                            <span class="mc-logo-main">MOORE'S CUSTOMZ</span>
                            <span class="mc-logo-sub">Custom Paint & Airbrush Studio</span>
                        </span>
                    </a>
                <?php else : ?>
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="mc-brand-link">
                        <span class="mc-logo-mark" aria-hidden="true">MC</span>
                        <span class="mc-logo-text">
                            <span class="mc-logo-main">MOORE'S CUSTOMZ</span>
                            <span class="mc-logo-sub">Custom Paint & Airbrush Studio</span>
                        </span>
                    </a>
                <?php endif; ?>
            </div>
            <button class="mc-nav-toggle" type="button" aria-controls="mc-primary-menu" aria-expanded="false" aria-label="Open menu">
                <span class="sr-only">Menu</span>
                <span class="mc-nav-toggle-bars" aria-hidden="true"></span>
            </button>
        </div>
        
        <nav>
            <ul class="mc-menu" id="mc-primary-menu">
                <li><a href="#services">Services</a></li>
                <li><a href="#work">Gallery</a></li>
                <li><a href="#auth">About</a></li>
                <li><a href="#contact">Contact</a></li>
                <li><button class="mc-menu-auth" type="button" data-auth-open>Login</button></li>
            </ul>
        </nav>
        
        <div class="mc-cta">
            <button class="mc-btn-outline mc-btn-login" type="button" data-auth-open>Client Login</button>
            <a href="#contact" class="mc-btn-outline">Request Quote</a>
        </div>
    </div>
</header>
